/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util.text.messages.multiline;

import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.commands.Commands;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import de.z0rdak.yawp.platform.Services;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.text.Messages;
import de.z0rdak.yawp.util.text.messages.multiline.MultiLineMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class RegionStateMessage
implements MultiLineMessage<IProtectedRegion> {
    private final IProtectedRegion region;
    private final List<class_2561> regionState;

    public RegionStateMessage(IProtectedRegion region) {
        this.region = region;
        this.regionState = new ArrayList<class_2561>();
    }

    public static RegionStateMessage of(IProtectedRegion region) {
        return new RegionStateMessage(region);
    }

    public static class_5250 buildRegionStateLink(IProtectedRegion region) {
        class_5250 linkText = class_2561.method_48321((String)"cli.msg.info.region.state.link.text", (String)"State");
        class_5250 hoverText = class_2561.method_48322((String)"cli.msg.info.region.state.link.hover", (String)"Show region state for %s", (Object[])new Object[]{region.getName()});
        String cmd = Commands.buildRegionStateCmd(region);
        return ChatComponentBuilder.buildExecuteCmdLink(linkText, hoverText, cmd, class_2558.class_2559.field_11750, Messages.LINK_COLOR);
    }

    public static class_5250 buildRegionRenameLink(IMarkableRegion region) {
        String cmd = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), CommandConstants.RENAME.toString(), "");
        class_5250 text = class_2561.method_48321((String)"cli.msg.info.region.state.rename.link.text", (String)"rename");
        class_5250 hover = class_2561.method_48322((String)"cli.msg.info.region.state.rename.link.hover", (String)"Rename region '%s'", (Object[])new Object[]{region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLink(text, hover, cmd, class_2558.class_2559.field_11745, Messages.LINK_COLOR);
    }

    public static class_5250 buildRegionPriorityComponent(IMarkableRegion region) {
        int defaultPriorityInc = Services.REGION_CONFIG.getDefaultPriorityInc();
        String incPriorityCmd = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), CommandConstants.STATE.toString(), CommandConstants.PRIORITY.toString(), CommandConstants.INC.toString(), String.valueOf(defaultPriorityInc));
        class_5250 incLinkText = class_2561.method_48322((String)"cli.msg.info.region.state.priority.increase.link.text", (String)"+%s", (Object[])new Object[]{defaultPriorityInc});
        class_5250 incHoverText = class_2561.method_48322((String)"cli.msg.info.region.state.priority.increase.link.hover", (String)"Increase region priority by %s", (Object[])new Object[]{defaultPriorityInc});
        class_5250 increaseLink = ChatComponentBuilder.buildExecuteCmdComponent(incLinkText, incHoverText, incPriorityCmd, class_2558.class_2559.field_11750, Messages.ADD_CMD_COLOR);
        String decPriorityCmd = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), CommandConstants.STATE.toString(), CommandConstants.PRIORITY.toString(), CommandConstants.DEC.toString(), String.valueOf(defaultPriorityInc));
        class_5250 decLinkText = class_2561.method_48322((String)"cli.msg.info.region.state.priority.decrease.link.text", (String)"+%s", (Object[])new Object[]{defaultPriorityInc});
        class_5250 decHoverText = class_2561.method_48322((String)"cli.msg.info.region.state.priority.decrease.link.hover", (String)"Decrease region priority by %s", (Object[])new Object[]{defaultPriorityInc});
        class_5250 decreaseLink = ChatComponentBuilder.buildExecuteCmdComponent(decLinkText, decHoverText, decPriorityCmd, class_2558.class_2559.field_11750, Messages.REMOVE_CMD_COLOR);
        String setPriorityCmd = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), CommandConstants.STATE.toString(), CommandConstants.PRIORITY.toString(), "");
        class_5250 setPriorityLinkText = class_2561.method_48322((String)"cli.msg.info.region.state.priority.set.link.text", (String)"%s", (Object[])new Object[]{region.getPriority()});
        class_5250 setPriorityHoverText = class_2561.method_48321((String)"cli.msg.info.region.state.priority.set.link.hover", (String)"Set priority for region");
        class_5250 setPriorityLink = ChatComponentBuilder.buildExecuteCmdComponent(setPriorityLinkText, setPriorityHoverText, setPriorityCmd, class_2558.class_2559.field_11745, Messages.LINK_COLOR);
        return Messages.substitutable("%s %s %s", setPriorityLink, increaseLink, decreaseLink);
    }

    public static class_5250 buildAllLocalAlertToggleLink(IProtectedRegion dimRegion) {
        class_5250 enableLinkTextKey = class_2561.method_48321((String)"cli.msg.info.region.state.enable.all.true.link.text", (String)"all-on");
        class_5250 enableHoverTextKey = class_2561.method_48322((String)"cli.msg.info.region.state.enable.all.true.link.hover", (String)"Enables alert for all local regions of %s", (Object[])new Object[]{dimRegion.getName()});
        class_5250 disableLinkTextKey = class_2561.method_48321((String)"cli.msg.info.region.state.enable.all.false.link.text", (String)"all-off");
        class_5250 disableHoverTextKey = class_2561.method_48322((String)"cli.msg.info.region.state.enable.all.false.link.hover", (String)"Disables alert for all local regions of %s", (Object[])new Object[]{dimRegion.getName()});
        String enableCmd = Commands.buildCommandStr(CommandConstants.DIM.toString(), dimRegion.getName(), CommandConstants.STATE.toString(), CommandConstants.ALERT_LOCAL.toString(), Boolean.TRUE.toString());
        String disableCmd = Commands.buildCommandStr(CommandConstants.DIM.toString(), dimRegion.getName(), CommandConstants.STATE.toString(), CommandConstants.ALERT_LOCAL.toString(), Boolean.FALSE.toString());
        class_5250 activeAlertLink = ChatComponentBuilder.buildExecuteCmdComponent(enableLinkTextKey, enableHoverTextKey, enableCmd, class_2558.class_2559.field_11750, class_124.field_1060);
        class_5250 disableAlertLink = ChatComponentBuilder.buildExecuteCmdComponent(disableLinkTextKey, disableHoverTextKey, disableCmd, class_2558.class_2559.field_11750, class_124.field_1061);
        return Messages.substitutable("%s %s", activeAlertLink, disableAlertLink);
    }

    public static class_5250 buildAllLocalEnableComponent(IProtectedRegion dimRegion) {
        class_5250 enableLinkTextKey = class_2561.method_48321((String)"cli.msg.info.region.state.alert.all.true.link.text", (String)"all-on");
        class_5250 enableHoverTextKey = class_2561.method_48322((String)"cli.msg.info.region.state.alert.all.true.link.hover", (String)"Activates all local regions of %s", (Object[])new Object[]{dimRegion.getName()});
        class_5250 disableLinkTextKey = class_2561.method_48321((String)"cli.msg.info.region.state.alert.all.false.link.text", (String)"all-off");
        class_5250 disableHoverTextKey = class_2561.method_48322((String)"cli.msg.info.region.state.alert.all.false.link.hover", (String)"Disables all local regions of %s", (Object[])new Object[]{dimRegion.getName()});
        String enableCmd = Commands.buildCommandStr(CommandConstants.DIM.toString(), dimRegion.getName(), CommandConstants.STATE.toString(), CommandConstants.ENABLE_LOCAL.toString(), Boolean.TRUE.toString());
        String disableCmd = Commands.buildCommandStr(CommandConstants.DIM.toString(), dimRegion.getName(), CommandConstants.STATE.toString(), CommandConstants.ENABLE_LOCAL.toString(), Boolean.FALSE.toString());
        class_5250 activeAlertLink = ChatComponentBuilder.buildExecuteCmdComponent(enableLinkTextKey, enableHoverTextKey, enableCmd, class_2558.class_2559.field_11750, class_124.field_1060);
        class_5250 disableAlertLink = ChatComponentBuilder.buildExecuteCmdComponent(disableLinkTextKey, disableHoverTextKey, disableCmd, class_2558.class_2559.field_11750, class_124.field_1061);
        return Messages.substitutable("%s %s", activeAlertLink, disableAlertLink);
    }

    public static class_5250 buildRegionEnableComponent(IProtectedRegion region) {
        String linkTextKey = "cli.msg.info.region.state.enable." + region.isActive() + ".link.text";
        String linkFallback = region.isActive() ? "yes" : "no";
        String hoverTextKey = "cli.msg.info.region.state.enable." + !region.isActive() + ".link.hover";
        String hoverFallback = !region.isActive() ? "Enable flag checks" : "Disable flag checks";
        class_5250 linkText = class_2561.method_48321((String)linkTextKey, (String)linkFallback);
        class_5250 hoverText = class_2561.method_48321((String)hoverTextKey, (String)hoverFallback);
        class_124 color = region.isActive() ? class_124.field_1060 : class_124.field_1080;
        String cmd = Commands.buildRegionStateEnableToggleCmd(region);
        return ChatComponentBuilder.buildExecuteCmdComponent(linkText, hoverText, cmd, class_2558.class_2559.field_11750, color);
    }

    public static class_5250 buildRegionAlertToggleLink(IProtectedRegion region) {
        String linkTextKey = "cli.msg.info.region.state.alert." + !region.isMuted() + ".link.text";
        String hoverTextKey = "cli.msg.info.region.state.alert." + region.isMuted() + ".link.hover";
        String linkFallback = region.isMuted() ? "off" : "on";
        String hoverFallback = !region.isMuted() ? "Turn flag alerts off" : "Turn flag alerts on";
        class_5250 linkText = class_2561.method_48321((String)linkTextKey, (String)linkFallback);
        class_5250 hoverText = class_2561.method_48321((String)hoverTextKey, (String)hoverFallback);
        class_124 color = region.isMuted() ? class_124.field_1080 : class_124.field_1060;
        String cmd = Commands.buildRegionStateAlertToggleCmd(region);
        return ChatComponentBuilder.buildExecuteCmdComponent(linkText, hoverText, cmd, class_2558.class_2559.field_11750, color);
    }

    @Override
    public IProtectedRegion getContent() {
        return this.region;
    }

    @Override
    public List<class_2561> getLines() {
        class_5250 header = ChatComponentBuilder.buildHeader(class_2561.method_48322((String)"cli.msg.info.header.for", (String)"== %s for %s ==", (Object[])new Object[]{RegionStateMessage.buildRegionStateLink(this.region), ChatLinkBuilder.buildRegionInfoLink(this.region)}));
        this.regionState.add((class_2561)header);
        class_5250 regionEnableComponent = RegionStateMessage.buildRegionEnableComponent(this.region);
        class_5250 regionAlertComponent = RegionStateMessage.buildRegionAlertToggleLink(this.region);
        if (this.region.getRegionType() == RegionType.DIMENSION) {
            class_5250 enableComp = Messages.substitutable("%s | %s", regionEnableComponent, RegionStateMessage.buildAllLocalEnableComponent(this.region));
            class_5250 alertComp = Messages.substitutable("%s | %s", regionAlertComponent, RegionStateMessage.buildAllLocalAlertToggleLink(this.region));
            this.regionState.add((class_2561)ChatComponentBuilder.buildInfoComponent("cli.msg.info.region.state.enable", "Enabled", enableComp));
            this.regionState.add((class_2561)ChatComponentBuilder.buildInfoComponent("cli.msg.info.region.state.alert", "Alert", alertComp));
            return this.regionState;
        }
        if (this.region.getRegionType() == RegionType.LOCAL) {
            IMarkableRegion localRegion = (IMarkableRegion)this.region;
            class_5250 name = ChatComponentBuilder.buildInfoComponent("cli.msg.info.region.state.name", "Name", RegionStateMessage.buildRegionRenameLink(localRegion));
            class_5250 priority = ChatComponentBuilder.buildInfoComponent("cli.msg.info.region.state.priority", "Priority", RegionStateMessage.buildRegionPriorityComponent(localRegion));
            this.regionState.add((class_2561)name);
            this.regionState.add((class_2561)priority);
        }
        class_5250 enableComp = ChatComponentBuilder.buildInfoComponent("cli.msg.info.region.state.enable", "Enabled", regionEnableComponent);
        class_5250 alertComp = ChatComponentBuilder.buildInfoComponent("cli.msg.info.region.state.alert", "Alert", regionAlertComponent);
        this.regionState.add((class_2561)Messages.substitutable("%s, %s", enableComp, alertComp));
        return this.regionState;
    }
}

